package gov.va.vinci.dart.db.impl;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.biz.RequestLocationDocument;
import gov.va.vinci.dart.db.RequestLocationDocumentDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class RequestLocationDocumentDAOImpl extends HibernateDAO implements RequestLocationDocumentDAO {

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestLocationDocument> listByRequestId(final int requestId) {
		Query q = createQuery("from RequestLocationDocument where requestId=:rid");
		q.setParameter("rid",requestId);
	
		try {
			return (List<RequestLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result then.
			return new ArrayList<RequestLocationDocument>();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestLocationDocument> listByDocumentId(final int documentId) {
		Query q = createQuery("from RequestLocationDocument where documentId=:did");
		q.setParameter("did", documentId);
	
		try {
			return (List<RequestLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result then.
			return new ArrayList<RequestLocationDocument>();
		}
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestLocationDocument> listByRequestAndLocationId(final int requestId, final int locationId) {
		Query q = createQuery("from RequestLocationDocument where requestId=:rid and locationId=:lid");
		q.setParameter("rid",requestId);
		q.setParameter("lid",locationId);
	
		try {
			return (List<RequestLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result then.
			return new ArrayList<RequestLocationDocument>();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestLocationDocument> listActiveDocsByRequestAndLocationId(final int requestId, final int locationId) {
		Query q = createQuery("from RequestLocationDocument where requestId=:rid and locationId=:lid and active=true");
		q.setParameter("rid",requestId);
		q.setParameter("lid",locationId);
	
		try {
			return (List<RequestLocationDocument>) q.getResultList();
		} catch (NoResultException e) {
			// whatever - give me an empty result then.
			return new ArrayList<RequestLocationDocument>();
		}
	}
	
	
	@Override
	public void save(RequestLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(document);
	}

	@Override
	public void delete(RequestLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(document);
	}
}
